<?php
include 'inc/config.php'; // DB connection only

$page = $service->query(
    "SELECT title, description 
     FROM tbl_page 
     WHERE id = 1 AND status = 1"
)->fetch_assoc();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?php echo $page['title']; ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Minimal mobile-friendly styling -->
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 16px;
            line-height: 1.6;
            background: #ffffff;
            color: #333;
        }
        h1, h2, h3 {
            margin-top: 20px;
        }
        a {
            color: #007bff;
            text-decoration: none;
        }
        img {
            max-width: 100%;
            height: auto;
        }
    </style>
</head>
<body>

<?php if($page) { ?>

    <h1><?php echo $page['title']; ?></h1>

    <!-- Render HTML from DB -->
    <?php echo $page['description']; ?>

<?php } else { ?>

    <p>Privacy Policy not available.</p>

<?php } ?>

</body>
</html>
