<?php 
require dirname( dirname(__FILE__) ).'/inc/config.php';
require dirname( dirname(__FILE__) ).'/inc/FunctionQuery.php';
require dirname( dirname(__FILE__) ).'/inc/keyvaliation.php';

header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);

if (empty($data['owner_id'])) {
    $returnArr = array(
        "ResponseCode" => "401",
        "Result" => "false",
        "ResponseMsg" => "Something went wrong! owner_id is missing."
    );
} else {
    $owner_id = $service->real_escape_string($data['owner_id']);

    // Join with tbl_lorry to get lorry_no
    $query = "
        SELECT s.*, l.lorry_no 
        FROM sub_drivers s 
        LEFT JOIN tbl_lorry l ON s.lorry_id = l.id 
        WHERE s.owner_id = '$owner_id'
    ";

    $check = $service->query($query);
    $subdrivers = array();

    while ($row = $check->fetch_assoc()) {
        
        $subdrivers[] = $row;
    }

    $returnArr = array(
        "SubDriverList" => $subdrivers,
        "ResponseCode" => "200",
        "Result" => "true",
        "ResponseMsg" => "Sub-driver list fetched successfully!"
    );
}

echo json_encode($returnArr);
