<?php 
require dirname(dirname(__FILE__)).'/inc/config.php';
header('Content-type: application/json');

$data = json_decode(file_get_contents('php://input'), true);

// Validate input
if (empty($data['mobile']) && empty($data['email'])) {
    $returnArr = array(
        "ResponseCode" => "401",
        "Result" => "false",
        "ResponseMsg" => "Mobile number or Email is required!"
    );
} 
else 
{
    // Check by mobile
    if (!empty($data['mobile'])) {

        $mobile = strip_tags(mysqli_real_escape_string($service, $data['mobile']));
        $check = $service->query(
            "SELECT id FROM tbl_lowner WHERE mobile = '$mobile'"
        )->num_rows;

        if ($check > 0) {
            $returnArr = array(
                "ResponseCode" => "401",
                "Result" => "false",
                "ResponseMsg" => "Already Exist Mobile Number!",
                "otp_auth" => $set['otp_auth']
            );
        } else {
            $returnArr = array(
                "ResponseCode" => "200",
                "Result" => "true",
                "ResponseMsg" => "New Mobile Number!",
                "otp_auth" => $set['otp_auth']
            );
        }

    } 
    // Check by email
    else if (!empty($data['email'])) {

        $email = strip_tags(mysqli_real_escape_string($service, $data['email']));
        $check = $service->query(
            "SELECT id FROM tbl_lowner WHERE email = '$email'"
        )->num_rows;

        if ($check > 0) {
            $returnArr = array(
                "ResponseCode" => "401",
                "Result" => "false",
                "ResponseMsg" => "Already Exist Email Address!",
                "otp_auth" => $set['otp_auth']
            );
        } else {
            $returnArr = array(
                "ResponseCode" => "200",
                "Result" => "true",
                "ResponseMsg" => "New Email Address!",
                "otp_auth" => $set['otp_auth']
            );
        }
    }
}

echo json_encode($returnArr);
