<?php 
require dirname(dirname(__FILE__)).'/inc/config.php';
header('Content-type: application/json');

$data = json_decode(file_get_contents('php://input'), true);

// Validate input
if (
    (empty($data['mobile']) || empty($data['ccode'])) 
    && empty($data['email'])
) {
    $returnArr = array(
        "ResponseCode" => "401",
        "Result" => "false",
        "ResponseMsg" => "Mobile number or Email is required!"
    );
} 
else 
{
    // Check by mobile
    if (!empty($data['mobile']) && !empty($data['ccode'])) {

        $mobile = strip_tags(mysqli_real_escape_string($service, $data['mobile']));
        $ccode  = strip_tags(mysqli_real_escape_string($service, $data['ccode']));

        $check = $service->query(
            "SELECT id FROM tbl_user WHERE mobile = '$mobile' AND ccode = '$ccode'"
        )->num_rows;

        if ($check > 0) {
            $returnArr = array(
                "ResponseCode" => "401",
                "Result" => "false",
                "ResponseMsg" => "Mobile number already exists!",
                "otp_auth" => $set['otp_auth']
            );
        } else {
            $returnArr = array(
                "ResponseCode" => "200",
                "Result" => "true",
                "ResponseMsg" => "New mobile number!",
                "otp_auth" => $set['otp_auth']
            );
        }

    } 
    // Check by email
    else if (!empty($data['email'])) {

        $email = strip_tags(mysqli_real_escape_string($service, $data['email']));

        $check = $service->query(
            "SELECT id FROM tbl_user WHERE email = '$email'"
        )->num_rows;

        if ($check > 0) {
            $returnArr = array(
                "ResponseCode" => "401",
                "Result" => "false",
                "ResponseMsg" => "Email already exists!"
            );
        } else {
            $returnArr = array(
                "ResponseCode" => "200",
                "Result" => "true",
                "ResponseMsg" => "New email!"
            );
        }
    }
}

echo json_encode($returnArr);