<?php 
require dirname(dirname(__FILE__)).'/inc/config.php';
require dirname(dirname(__FILE__)).'/inc/keyvaliation.php';
header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);

$pick_state_name = isset($data['pick_state_name']) ? trim($data['pick_state_name']) : '';
$drop_state_name = isset($data['drop_state_name']) ? trim($data['drop_state_name']) : '';

if ($pick_state_name == '' || $drop_state_name == '') {
    $returnArr = array(
        "ResponseCode" => "401",
        "Result" => "false",
        "ResponseMsg" => "Something Went Wrong!"
    );
} else {

    $pick_state_name = mysqli_real_escape_string($service, $pick_state_name);
    $drop_state_name = mysqli_real_escape_string($service, $drop_state_name);

    // 🔍 Try matching by partial and phonetic similarity
    $pick_sql = "
        SELECT id FROM tbl_state
        WHERE 
            title LIKE '%$pick_state_name%' COLLATE utf8mb4_general_ci
            OR '$pick_state_name' LIKE CONCAT('%', title, '%')
            OR SOUNDEX(title) = SOUNDEX('$pick_state_name')
        LIMIT 1
    ";

    $drop_sql = "
        SELECT id FROM tbl_state
        WHERE 
            title LIKE '%$drop_state_name%' COLLATE utf8mb4_general_ci
            OR '$drop_state_name' LIKE CONCAT('%', title, '%')
            OR SOUNDEX(title) = SOUNDEX('$drop_state_name')
        LIMIT 1
    ";

    $sel = $service->query($pick_sql);
    $pstate = $sel ? $sel->fetch_assoc() : null;
    $pstate_id = !empty($pstate['id']) ? $pstate['id'] : "0";

    $sels = $service->query($drop_sql);
    $dstate = $sels ? $sels->fetch_assoc() : null;
    $dstate_id = !empty($dstate['id']) ? $dstate['id'] : "0";

    // 🚦Response Logic
    if ($pstate_id == '0' && $dstate_id == '0') {
        $returnArr = array(
            "pick_state_id" => $pstate_id,
            "drop_state_id" => $dstate_id,
            "ResponseCode" => "401",
            "Result" => "false",
            "ResponseMsg" => "Change Pick Up and Drop Locations — Service Not Available Here!"
        );
    } elseif ($pstate_id != '0' && $dstate_id == '0') {
        $returnArr = array(
            "pick_state_id" => $pstate_id,
            "drop_state_id" => $dstate_id,
            "ResponseCode" => "401",
            "Result" => "false",
            "ResponseMsg" => "Change Drop Location — Service Not Available Here!"
        );
    } elseif ($pstate_id == '0' && $dstate_id != '0') {
        $returnArr = array(
            "pick_state_id" => $pstate_id,
            "drop_state_id" => $dstate_id,
            "ResponseCode" => "401",
            "Result" => "false",
            "ResponseMsg" => "Change Pick Up Location — Service Not Available Here!"
        );
    } else {
        $returnArr = array(
            "pick_state_id" => $pstate_id,
            "drop_state_id" => $dstate_id,
            "ResponseCode" => "200",
            "Result" => "true",
            "ResponseMsg" => "State IDs Found!"
        );
    }
}

echo json_encode($returnArr);
?>
