<?php
include 'inc/config.php'; // DB connection and $service object

$message = '';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email']);

    if (filter_var($email, FILTER_VALIDATE_EMAIL)) {

        // Check if user exists
        $user = $service->query("SELECT id, name FROM tbl_user WHERE email='".$service->real_escape_string($email)."'")->fetch_assoc();

        if ($user) {
            // Mark account as deleted / request deletion (soft delete)
            // $service->query("UPDATE tbl_users SET status='deleted', deletion_requested=NOW() WHERE id=".$user['id']);

            $message = "Hi ".$email.", your account deletion request has been received. It will be processed within 24-48 hours.";
        } else {
            $message = "No account found with this email address.";
        }

    } else {
        $message = "Please enter a valid email address.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Account Deletion Request</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
    body { font-family: Arial; padding: 20px; background: #f9f9f9; }
    h1 { color: #333; }
    input, button { padding: 10px; margin: 5px 0; width: 100%; max-width: 400px; }
    button { background: #d9534f; color: #fff; border: none; cursor: pointer; }
    button:hover { background: #c9302c; }
    .message { margin: 15px 0; color: green; }
    .error { color: red; }
    .container { max-width: 500px; margin: auto; background: #fff; padding: 20px; border-radius: 6px; box-shadow: 0 0 10px rgba(0,0,0,0.1);}
</style>
</head>
<body>

<div class="container">
    <h1>Account Deletion</h1>
    <p>Enter your email address below to request account deletion. This action cannot be undone.</p>

    <?php if($message) { ?>
        <div class="message"><?php echo $message; ?></div>
    <?php } ?>

    <form method="POST">
        <input type="email" name="email" placeholder="Enter your registered email" required>
        <button type="submit">Request Deletion</button>
    </form>
</div>

</body>
</html>
