<?php 
require dirname(dirname(__FILE__)).'/inc/config.php';
require dirname(dirname(__FILE__)).'/inc/keyvaliation.php';
header('Content-type: application/json');

$data = json_decode(file_get_contents('php://input'), true);

$pick_state_name = trim($data['pick_state_name'] ?? '');
$drop_state_name = trim($data['drop_state_name'] ?? '');

if ($pick_state_name == '' || $drop_state_name == '') {
    $returnArr = array("ResponseCode"=>"401","Result"=>"false","ResponseMsg"=>"Something Went Wrong!");
    echo json_encode($returnArr);
    exit;
}

// Use LIKE for flexible matching and normalize spaces
$pick_state_name = mysqli_real_escape_string($service, $pick_state_name);
$drop_state_name = mysqli_real_escape_string($service, $drop_state_name);

// Try to find closest match using LIKE and handle possible misspellings
$sel = $service->query("
    SELECT id FROM tbl_state 
    WHERE REPLACE(LOWER(title), ' ', '') LIKE REPLACE(LOWER('%$pick_state_name%'), ' ', '') 
    LIMIT 1
")->fetch_assoc();

$pstate_id = $sel['id'] ?? "0";

$sels = $service->query("
    SELECT id FROM tbl_state 
    WHERE REPLACE(LOWER(title), ' ', '') LIKE REPLACE(LOWER('%$drop_state_name%'), ' ', '') 
    LIMIT 1
")->fetch_assoc();

$dstate_id = $sels['id'] ?? "0";

if ($pstate_id == '0' && $dstate_id == '0') {
    $returnArr = array(
        "pick_state_id" => $pstate_id,
        "drop_state_id" => $dstate_id,
        "ResponseCode" => "401",
        "Result" => "false",
        "ResponseMsg" => "Change Pick Up Location And Drop Location. We do not provide service at these locations."
    );
} else if ($pstate_id != '0' && $dstate_id == '0') {
    $returnArr = array(
        "pick_state_id" => $pstate_id,
        "drop_state_id" => $dstate_id,
        "ResponseCode" => "401",
        "Result" => "false",
        "ResponseMsg" => "Change Drop Location. We do not provide service at this location."
    );
} else if ($pstate_id == '0' && $dstate_id != '0') {
    $returnArr = array(
        "pick_state_id" => $pstate_id,
        "drop_state_id" => $dstate_id,
        "ResponseCode" => "401",
        "Result" => "false",
        "ResponseMsg" => "Change Pick Up Location. We do not provide service at this location."
    );
} else {
    $returnArr = array(
        "pick_state_id" => $pstate_id,
        "drop_state_id" => $dstate_id,
        "ResponseCode" => "200",
        "Result" => "true",
        "ResponseMsg" => "Get State Id!!"
    );
}

echo json_encode($returnArr);
?>
